#include "stdafx.h"
#include "version.h"
#include "SplExp.h"
#include "rwcommon.h"
#include "common.h"
#include "splshape.h"
#include "RpSpline.h"
#include "RwExp.h"
#include "SplDlg.h"

SPLExport::SPLExport(void)
{
}

SPLExport::~SPLExport(void)
{
}

int
SPLExport::ExtCount(void)
{
    return (1);
}

const TCHAR *
SPLExport::Ext(int n)
{
    const TCHAR *result =  _T("");

    switch (n)
    {
        case 0:
        {
            result = _T("SPL");
            break;
        }
    }

    return result;
}

const TCHAR *
SPLExport::LongDesc(void)
{
    return _T(SPLLongDescription);
}

const TCHAR *
SPLExport::ShortDesc(void)
{            
    return _T(SPLShortDescription);
}

const TCHAR *
SPLExport::AuthorName(void)
{            
    return _T(AUTHORNAME);
}

const TCHAR *
SPLExport::CopyrightMessage(void)
{    
    return _T(COPYRIGHT);
}

const TCHAR *
SPLExport::OtherMessage1(void) 
{        
    return _T("");
}

const TCHAR *
SPLExport::OtherMessage2(void)
{        
    return _T("");
}

unsigned int
SPLExport::Version(void)
{                
    return (VERSION);
}

void
SPLExport::ShowAbout(HWND hWnd)
{            
}


int
SPLExport::DoExport(const TCHAR *filename, ExpInterface *ei, Interface *gi, BOOL suppressPrompts, DWORD options) 
{    
    BOOL success = FALSE;
    CSplDlg dlg;

    hGMaxHWnd = gi->GetMAXHWnd();
    
    /* convert the selected shape */
    int nNumSelectedNodes = gi->GetSelNodeCount();
    
    if (nNumSelectedNodes == 0)
    {
        MessageBox(hGMaxHWnd, "Nothing selected, please select the shape to export",
            SPLExporterTitle, MB_OK );
    }
    else if (nNumSelectedNodes > 1)
    {
        MessageBox(hGMaxHWnd, "Please select only the shape to export",
            SPLExporterTitle, MB_OK );
    }
    else
    {
        /* setup & display the Spline export dialog */
        dlg.m_nScaleFactor = 1.0f;    
        if (dlg.DoModal() == IDOK)
        {
            m_nScaleFactor = dlg.m_nScaleFactor;        
        }
        else
        {
            return (TRUE);
        }

        m_rwlib = new RwLib(hGMaxHWnd, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE);
        /* setup RW */
        if (!m_rwlib->Opened())
        {
            MessageBox(hGMaxHWnd, "Failed to open RenderWare",SPLExporterTitle, MB_OK );
            return (TRUE);
        }
    
        INode *selectedNode = gi->GetSelNode(0);
        Object *selectedObj = selectedNode->EvalWorldState(0).obj;
        Matrix3 mat = selectedNode->GetObjTMAfterWSM(0, NULL);
            
        if (!selectedObj->CanConvertToType(Class_ID(SPLINESHAPE_CLASS_ID, 0)))
        {
            MessageBox(hGMaxHWnd, "The selected node cannot be converted to a spline",
                SPLExporterTitle, MB_OK );
        }
        else
        {
            RwV3d *knots;
			RwInt32 numknots, knot, spl;					      
            RwBool invalidKnots = FALSE;
            RpSpline *spline;
            RwStream *splStream;
            SplineShape *splobj = (SplineShape *) selectedObj->ConvertToType(0, Class_ID(SPLINESHAPE_CLASS_ID, 0));
			BezierShape bezobj = splobj->GetShape();
            if ((splStream = RwStreamOpen(rwSTREAMFILENAME, rwSTREAMWRITE, (char *)filename)) != NULL)
            {                                    
                for (spl = 0; spl < bezobj.SplineCount(); spl++)
                {
			        Spline3D *maxspline = bezobj.GetSpline(spl);
					      
                    numknots = maxspline->KnotCount();
			        knots = (RwV3d *) RwMalloc(sizeof(RwV3d) * numknots);
			        for (knot=0; knot<numknots; knot++)
			        {
			            Point3 knotPos = maxspline->GetKnotPoint(knot);

                        if (maxspline->GetKnotType(knot) != KTYPE_AUTO)
                        {
                            invalidKnots = TRUE;
                        }
                        knotPos = knotPos * mat;

				        knots[knot].x = knotPos.x;
				        knots[knot].y = knotPos.z;
				        knots[knot].z = -knotPos.y;
                        RwV3dScale(&knots[knot], &knots[knot], m_nScaleFactor);
		            }

                    if (invalidKnots)
                    {
                        MessageBox(hGMaxHWnd, "Non smooth knot found, exported spline may differ from original",
                            SPLExporterTitle, MB_OK );
                    }

                    if (maxspline->Closed())
                    {
                        spline = RpSplineCreate(numknots, rpSPLINETYPECLOSEDLOOPBSPLINE, knots);
                    }
                    else
                    {
                        spline = RpSplineCreate(numknots, rpSPLINETYPEOPENLOOPBSPLINE, knots);
                    }
					            
                    if (spline)
                    {
		                RpSplineStreamWrite(spline, splStream);
                    }
                    else
                    {
                        MessageBox(hGMaxHWnd, "Unknown error whilst creating spline",
                            SPLExporterTitle, MB_OK );
                    }
                }
                RwStreamClose(splStream, NULL);
            }
            else
            {
                MessageBox(hGMaxHWnd, "Failed to create stream",SPLExporterTitle, MB_OK );
            }
        }    

        delete (m_rwlib);
    }    

    return (TRUE);
}
	

